unit CoreClassesUnit;

interface

uses
  System.ComponentModel,
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes;

type
  Order = class;
  OrderItem = class;
  [UmlElement('Package', Id='99e62684-18a8-42cc-9180-20cf5d2a8a7a')]
  [EcoCodeGenVersion('2.0')]
  [UmlMetaAttribute('ownedElement', TypeOf(OrderItem))]
  [UmlMetaAttribute('ownedElement', TypeOf(Order))]
  CoreClasses = class
  public
  type
    [UmlElement('Association', Id='d1455439-eb9e-442a-bead-a377d163d4d8')]
    Association_1 = class
    end;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(CoreClasses))]
  [UmlCollection(TypeOf(Order))]
  IOrderList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Order;
    procedure set_Item(index: Integer; Value: Order);
    property Item[index: Integer]: Order read get_Item write set_Item; default;
    function Add(value: Order): Integer;
    function Contains(value: Order): Boolean;
    function IndexOf(value: Order): Integer;
    procedure Insert(index: Integer; value: Order);
    procedure Remove(value: Order);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  IOrderItemList = interface;
  [UmlElement(Id='ab921c36-172d-4075-82bc-09a2ef17d739')]
  [UmlTaggedValue('Eco.TableName', 'OrderTable')]
  Order = class(System.Object, ILoopBack)
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 4);
    const
      BillingAddress = Eco_FirstMember;
    const
      Customer = (Eco_LoopbackIndices.BillingAddress + 1);
    const
      ShippingAddress = (Eco_LoopbackIndices.Customer + 1);
    const
      OrderItem = (Eco_LoopbackIndices.ShippingAddress + 1);
    end;

    OrderListAdapter = class(ObjectListAdapter, IOrderList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Order;
      procedure set_Item(index: Integer; Value: Order);
      property Item[index: Integer]: Order read get_Item write set_Item; default;
      function Add(value: Order): Integer;
      function Contains(value: Order): Boolean;
      function IndexOf(value: Order): Integer;
      procedure Insert(index: Integer; value: Order);
      procedure Remove(value: Order);
    end;
  protected
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
    {$REGION 'Autogenerated ECO code'}
  public
    constructor Create(content: IContent); overload;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_ShippingAddress: string;
    procedure set_ShippingAddress(Value: string);
    [UmlElement(Id='89ff354e-33fa-49e4-987f-6edc96b1602d', Index=Eco_LoopbackIndices.ShippingAddress)]
    property ShippingAddress: string read get_ShippingAddress write set_ShippingAddress;
    function get_BillingAddress: string;
    procedure set_BillingAddress(Value: string);
    [UmlElement(Id='04d22821-93ce-4d95-b87d-ae331ef922fb', Index=Eco_LoopbackIndices.BillingAddress)]
    property BillingAddress: string read get_BillingAddress write set_BillingAddress;
    function get_Customer: string;
    procedure set_Customer(Value: string);
    [UmlElement(Id='895aaa32-d6c3-4e3b-8668-cfa97133b1cd', Index=Eco_LoopbackIndices.Customer)]
    property Customer: string read get_Customer write set_Customer;
    function get_OrderItem: IOrderItemList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.OrderItem, Id='214ab0' +
    '2a-ece3-497b-b441-ccf100c55cf2')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Association_1), Index=1)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    [UmlMetaAttribute('aggregation', AggregationKind.Composite)]
    property OrderItem: IOrderItemList read get_OrderItem;
    function AsIObject: IObjectInstance;
  strict protected
    eco_Content: IContent;
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
  strict private
    {$ENDREGION}
  public
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;
  [UmlCollection(TypeOf(OrderItem))]
  IOrderItemList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): OrderItem;
    procedure set_Item(index: Integer; Value: OrderItem);
    property Item[index: Integer]: OrderItem read get_Item write set_Item; default;
    function Add(value: OrderItem): Integer;
    function Contains(value: OrderItem): Boolean;
    function IndexOf(value: OrderItem): Integer;
    procedure Insert(index: Integer; value: OrderItem);
    procedure Remove(value: OrderItem);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  [UmlElement(Id='549eee14-f766-4998-8e01-87253e9a2069')]
  OrderItem = class(System.Object, ILoopBack)
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 4);
    const
      Product = Eco_FirstMember;
    const
      Quantity = (Eco_LoopbackIndices.Product + 1);
    const
      Price = (Eco_LoopbackIndices.Quantity + 1);
    const
      Order = (Eco_LoopbackIndices.Price + 1);
    end;

    OrderItemListAdapter = class(ObjectListAdapter, IOrderItemList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): OrderItem;
      procedure set_Item(index: Integer; Value: OrderItem);
      property Item[index: Integer]: OrderItem read get_Item write set_Item; default;
      function Add(value: OrderItem): Integer;
      function Contains(value: OrderItem): Boolean;
      function IndexOf(value: OrderItem): Integer;
      procedure Insert(index: Integer; value: OrderItem);
      procedure Remove(value: OrderItem);
    end;
  protected
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
    {$REGION 'Autogenerated ECO code'}
  public
    constructor Create(content: IContent); overload;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_Price: Double;
    procedure set_Price(Value: Double);
    [UmlElement(Id='6cbca4c5-dd18-4471-91dd-bb31dad88172', Index=Eco_LoopbackIndices.Price)]
    property Price: Double read get_Price write set_Price;
    function get_Quantity: Integer;
    procedure set_Quantity(Value: Integer);
    [UmlElement(Id='36adcf12-e8c9-45cb-b73a-2f07f38081da', Index=Eco_LoopbackIndices.Quantity)]
    property Quantity: Integer read get_Quantity write set_Quantity;
    function get_Product: string;
    procedure set_Product(Value: string);
    [UmlElement(Id='188bb1ba-8c6d-417f-a5f7-8365756486e7', Index=Eco_LoopbackIndices.Product)]
    property Product: string read get_Product write set_Product;
    function get_Order: Order;
    procedure set_Order(Value: Order);
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Order, Id='7fcd127e-5' +
    'e3c-4e65-8fb1-9a337d599aaf')]
    [UmlMetaAttribute('association', TypeOf(CoreClasses.Association_1), Index=0)]
    [UmlMetaAttribute('multiplicity', '0..1')]
    [UmlTaggedValue('Eco.ColumnName', 'OrderColumn')]
    property Order: Order read get_Order write set_Order;
    function AsIObject: IObjectInstance;
  strict protected
    eco_Content: IContent;
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
  strict private
    {$ENDREGION}
  public
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;

implementation

constructor Order.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

function Order.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Order.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Order.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

procedure Order.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;
{$ENDREGION}

constructor Order.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // If you add user code here, please remove the [EcoAutoMaintained] attribute
    // from the declaration in the interface section
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Order.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Order.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

constructor Order.OrderListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Order.OrderListAdapter.get_Item(index: Integer): Order;
begin
  Result := (Order(inherited Adaptee[index]));
end;

procedure Order.OrderListAdapter.set_Item(index: Integer; Value: Order);
begin
  inherited Adaptee[index] := value;
end;

function Order.OrderListAdapter.Add(value: Order): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Order.OrderListAdapter.Contains(value: Order): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Order.OrderListAdapter.IndexOf(value: Order): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Order.OrderListAdapter.Insert(index: Integer; value: Order);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Order.OrderListAdapter.Remove(value: Order);
begin
  Self.Adaptee.Remove(value);
end;



function Order.get_OrderItem: IOrderItemList;
begin
  Result := CoreClassesUnit.OrderItem.OrderItemListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.OrderItem))));
end;

function Order.get_Customer: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Customer)));
end;

procedure Order.set_Customer(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Customer, (System.Object(Value)));
end;

function Order.get_BillingAddress: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BillingAddress)));
end;

procedure Order.set_BillingAddress(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BillingAddress, (System.Object(Value)));
end;

function Order.get_ShippingAddress: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.ShippingAddress)));
end;

procedure Order.set_ShippingAddress(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.ShippingAddress, (System.Object(Value)));
end;

constructor OrderItem.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

function OrderItem.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure OrderItem.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure OrderItem.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

procedure OrderItem.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;
{$ENDREGION}

constructor OrderItem.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // If you add user code here, please remove the [EcoAutoMaintained] attribute
    // from the declaration in the interface section
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function OrderItem.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function OrderItem.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

constructor OrderItem.OrderItemListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function OrderItem.OrderItemListAdapter.get_Item(index: Integer): OrderItem;
begin
  Result := (OrderItem(inherited Adaptee[index]));
end;

procedure OrderItem.OrderItemListAdapter.set_Item(index: Integer; Value: OrderItem);
begin
  inherited Adaptee[index] := value;
end;

function OrderItem.OrderItemListAdapter.Add(value: OrderItem): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function OrderItem.OrderItemListAdapter.Contains(value: OrderItem): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function OrderItem.OrderItemListAdapter.IndexOf(value: OrderItem): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure OrderItem.OrderItemListAdapter.Insert(index: Integer; value: OrderItem);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure OrderItem.OrderItemListAdapter.Remove(value: OrderItem);
begin
  Self.Adaptee.Remove(value);
end;

function OrderItem.get_Order: Order;
begin
  Result := (CoreClassesUnit.Order(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Order)));
end;

procedure OrderItem.set_Order(Value: Order);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Order, (System.Object(Value)));
end;

function OrderItem.get_Product: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Product)));
end;

procedure OrderItem.set_Product(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Product, (System.Object(Value)));
end;

function OrderItem.get_Quantity: Integer;
begin
  Result := (Integer(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Quantity)));
end;

procedure OrderItem.set_Quantity(Value: Integer);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Quantity, (System.Object(Value)));
end;

function OrderItem.get_Price: Double;
begin
  Result := (Double(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Price)));
end;

procedure OrderItem.set_Price(Value: Double);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Price, (System.Object(Value)));
end;

{ CoreClasses }
















end.
